/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/*
 * Linux implementation of VFSStatPoint
 *
 * Contents:
 *
 * $Id: cxiVFSStats.c,v 1.2 2001/09/18 06:07:45 schmuck Exp $
 *
 * $Log: cxiVFSStats.c,v $
 * Revision 1.2  2001/09/18 06:07:45  schmuck
 * Get rid of some compiler warnings.
 *
 * Revision 1.1  2001/04/05 13:31:02  gjertsen
 * Continue C++ to C conversion with manual C++2C utility.
 * Changes primarily for vfs stat stuff.
 *
 * Revision 1.9  2000/12/15 13:56:37  gjertsen
 * Clean up documentation.
 *
 * Revision 1.8  2000/11/06 19:56:10  gjertsen
 * Linux code cleanup and put in build safeguards.
 *
 * Revision 1.7  2000/10/26 20:52:29  gjertsen
 * Purge out ugly USE_CWRAPPERS and export module symbols explicitly
 * as the default (in IA64 safe manner).
 *
// Revision 1.6  2000/08/29  18:31:53  dcraft
// Header include cleanup.
//
// Revision 1.5  2000/08/28  14:13:22  gjertsen
// Need to export all kernel symbols explicitly in IA64
// Linux due to bug with insmod.
//
// Revision 1.4  2000/08/07  22:33:07  dcraft
// Use new cxiGetTOD() time of day function for second,
// nanosecond needs.  Define 32 bit time types and start
// using in place of current on disk time_t types (necessary
// for 64 bit).  Use HiResTime where possible.
//
// Revision 1.3  2000/07/19  13:20:08  gjertsen
// Clean up code by adding typecasts, func prototypes, and misc compile fixes.
// Take care of module.h using `new' keyword for IA64.
//
// Revision 1.2  2000/06/07  16:54:09  eshel
// Change PDEBUG to TRACE
//
 */

#include <Shark-gpl.h>

#define DEFINE_VFSSTATS_GBL_VARS /* allocate storage for trace globals */

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/sched.h>
#include <linux/slab.h>

#include <cxiSystem.h>
#include <cxiVFSStats.h>

void VFSStatPoint_begin(VFSStatPoint_t *objPtr, enum VFSStatItem i)
{
  cxiGetTOD(&(objPtr->beginTime));
  objPtr->statItem = i;
}

void VFSStatPoint_end(VFSStatPoint_t *objPtr)
{
  cxiTimeStruc_t endTime;
  cxiTimeStruc_t t;

  if (objPtr->statItem != nullCall)
  {
    /* Get the current time and store in endTime */
    cxiGetTOD(&endTime);

    /* Calculate the new value of totalTime in vfsStats.data[statItem] as
         totalTime = totalTime + (endTime - beginTime) */
    t.tv_sec = vfsStats.data[objPtr->statItem].totalTime.tv_sec
                + endTime.tv_sec - objPtr->beginTime.tv_sec;
    t.tv_nsec = vfsStats.data[objPtr->statItem].totalTime.tv_nsec
                 + endTime.tv_nsec - objPtr->beginTime.tv_nsec;
    if (t.tv_nsec >= 1000000000)
    {
      t.tv_sec++;
      t.tv_nsec -= 1000000000;
    }
    else if (t.tv_nsec < 0)
    {
      t.tv_sec--;
      t.tv_nsec += 1000000000;
    }

    /* update the count and value of totalTime in vfsStats.data[statItem] */
    vfsStats.data[objPtr->statItem].cnt++;
    vfsStats.data[objPtr->statItem].totalTime = t;
  }
}

#ifdef KCSTRACE
void cxiKcsTraceInfo(int index, int value)
{
  current->kcst_info.data[index] = value;
}
#endif
